<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminMaps extends pjAdmin
{
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			if (isset($_POST['map_update']))
			{
				$pjTableModel = pjTableModel::factory();
				
				if (isset($_FILES['path']))
				{
					$pjImage = new pjImage();
					if ($pjImage->getErrorCode() !== 200)
					{
						$pjImage->setAllowedTypes(array('image/png', 'image/gif', 'image/jpg', 'image/jpeg', 'image/pjpeg'));
						if ($pjImage->load($_FILES['path']))
						{
							$resp = $pjImage->isConvertPossible();
							if ($resp['status'] === true)
							{
								$path = PJ_UPLOAD_PATH . 'maps/map.' . $pjImage->getExtension();
								$pjImage->loadImage();
								$pjImage->saveImage($path);
							}
						}
					}
				}
				if (isset($_POST['use_map']) && (int) $this->option_arr['o_use_map'] === 0)
				{
					pjOptionModel::factory()
								->where('foreign_id', $this->getForeignId())
								->where('`key`', 'o_use_map')
								->limit(1)
								->modifyAll(array('value' => '1|0::1'));
				} elseif (!isset($_POST['use_map']) && (int) $this->option_arr['o_use_map'] === 1) {
					pjOptionModel::factory()
								->where('foreign_id', $this->getForeignId())
								->where('`key`', 'o_use_map')
								->limit(1)
								->modifyAll(array('value' => '1|0::0'));
				}
				if (!isset($_POST['seats']))
				{
					$pjTableModel->reset()->truncate($pjTableModel->getTable());
				}
				if (isset($_POST['seats']))
				{
					$seat1_arr = array_values($pjTableModel->findAll()->getDataPair('id', 'id'));
					$seat2_arr = array();
					$sdata = array();
					foreach ($_POST['seats'] as $seat)
					{
						list($id, $sdata['width'], $sdata['height'], $sdata['left'], $sdata['top'], $sdata['name'], $sdata['seats'], $sdata['minimum']) = explode("|", $seat);
						$seat2_arr[] = $id;
						$pjTableModel->reset()->where('id', $id)->limit(1)->modifyAll($sdata);
					}
					$diff = array_diff($seat1_arr, $seat2_arr);
					if (count($diff) > 0)
					{
						$pjTableModel->reset()->whereIn('id', $diff)->eraseAll();
					}
				}
				if (isset($_POST['seats_new']))
				{
					$sdata = array();
					foreach ($_POST['seats_new'] as $seat)
					{
						list(, $sdata['width'], $sdata['height'], $sdata['left'], $sdata['top'], $sdata['name'], $sdata['seats'], $sdata['minimum']) = explode("|", $seat);
						$pjTableModel->reset()->setAttributes($sdata)->insert();
					}
				}
				
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminMaps&action=pjActionIndex&err=AM01&id=1&tab_id=" . $_POST['tab_id']);
			}

			$this->set('seat_arr', pjTableModel::factory()->findAll()->getData());
			
			$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('pjAdminMaps.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteFile()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$map = PJ_UPLOAD_PATH . 'maps/map.jpg';
			if (is_file($map))
			{
				@unlink($map);
				pjTableModel::factory()->truncate();
			}
		}
	}
	
	public function pjActionSaveSeat()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjTableModel = pjTableModel::factory();
			
			$sdata = $resp = array();
			list($id, $sdata['width'], $sdata['height'], $sdata['left'], $sdata['top'],) = explode("|", $_POST['hidden']);
			if ((int) $id > 0)
			{
				# Update
				$pjTableModel->where('id', $id)->limit(1)->modifyAll(array_merge($sdata, $_POST));
				$resp = array('code' => 201, 'id' => $id);
			} else {
				# Save
				$insert_id = $pjTableModel->reset()->setAttributes(array_merge($sdata, $_POST))->insert()->getInsertId();
				if ($insert_id !== false && (int) $insert_id > 0)
				{
					$resp = array('code' => 200, 'id' => $insert_id);
				} else {
					$resp = array('code' => 100);
				}
			}
			pjAppController::jsonResponse($resp);
		}
	}
	
	public function pjActionDeleteSeat()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			
		}
	}
}
?>