<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjCron extends pjAppController
{
	public function pjActionIndex()
	{
		$this->setLayout('pjActionEmpty');
		
		$pjBookingModel = pjBookingModel::factory();
		$pjBookingTableModel = pjBookingTableModel::factory();
		$pjTableModel = pjTableModel::factory();
		
		$option_arr = pjOptionModel::factory()->getPairs($this->getForeignId());
		
		if ($option_arr['o_reminder_enable'] == 'Yes')
		{
			$pjMultiLangModel = pjMultiLangModel::factory();
			
			$pjEmail = new pjEmail();
			$pjEmail->setContentType("text/html");
			if ($option_arr['o_send_email'] == 'smtp')
			{
				$pjEmail
					->setTransport('smtp')
					->setSmtpHost($option_arr['o_smtp_host'])
					->setSmtpPort($option_arr['o_smtp_port'])
					->setSmtpUser($option_arr['o_smtp_user'])
					->setSmtpPass($option_arr['o_smtp_pass'])
					->setSender($option_arr['o_smtp_user'])
				;
			}	
			$hours_email = (int) $option_arr['o_reminder_email_before'];
			
			$arr = $pjBookingModel	->where('t1.status', 'confirmed')
									->where('t1.reminder_email', '0')
									->where("(UNIX_TIMESTAMP() BETWEEN (UNIX_TIMESTAMP(t1.dt) - " . $hours_email * 3600 . ") AND UNIX_TIMESTAMP(t1.dt) )")
									->findAll()->getData();
			foreach ($arr as $booking_arr)
			{
				$pjBookingTableModel->reset()
									->select("t1.*, t2.name")
									->join('pjTable', 't1.table_id = t2.id', 'left')
									->where('t1.booking_id', $booking_arr['id']);
				$booking_arr['table_arr'] = $pjBookingTableModel->findAll()->getData();
				
				$data = pjAppController::getData($option_arr, $booking_arr, PJ_SALT, $this->getLocaleId(), false);
				
				$lang_message = $pjMultiLangModel->reset()->select('t1.*')
										 ->where('t1.model','pjOption')
										 ->where('t1.locale', $this->getLocaleId())
										 ->where('t1.field', 'o_reminder_body')
										 ->limit(0, 1)
										 ->findAll()->getData();
				$lang_subject = $pjMultiLangModel->reset()->select('t1.*')
										 ->where('t1.model','pjOption')
										 ->where('t1.locale', $this->getLocaleId())
										 ->where('t1.field', 'o_reminder_subject')
										 ->limit(0, 1)
										 ->findAll()->getData();
										 
				if (count($lang_message) === 1 && count($lang_subject) === 1)
				{
					$message = str_replace($data['search'], $data['replace'], $lang_message[0]['content']);
					$pjEmail
							->setTo($booking_arr['c_email'])
							->setFrom($this->getAdminEmail())
							->setSubject($lang_subject[0]['content'])
							->send(pjUtil::textToHtml($message));
					
					$pjBookingModel	->reset()
									->setAttributes(array('id' => $booking_arr['id']))
									->modify(array('reminder_email' => 1));
				}
			}
			
			$smsPlugin = (pjObject::getPlugin('pjSms') !== NULL);
			if($smsPlugin)
			{
				$hours_sms = (int) $option_arr['o_reminder_sms_hours'];
					
				$arr = $pjBookingModel
					->reset()
					->where('t1.reminder_sms', '0')
					->where('t1.status', 'confirmed')
					->where("(UNIX_TIMESTAMP() BETWEEN (UNIX_TIMESTAMP(t1.dt) - " . $hours_email * 3600 . ") AND UNIX_TIMESTAMP(t1.dt) )")
					->findAll()->getData();
				foreach ($arr as $booking_arr)
				{
					if (empty($booking_arr['c_phone']))
					{
						continue;
					}
					$pjBookingTableModel->reset()
										->select("t1.*, t2.name")
										->join('pjTable', 't1.table_id = t2.id', 'left')
										->where('t1.booking_id', $booking_arr['id']);
					$booking_arr['table_arr'] = $pjBookingTableModel->findAll()->getData();
					
					$data = pjAppController::getData($option_arr, $booking_arr, PJ_SALT, $this->getLocaleId(), true);
					
					$lang_message = $pjMultiLangModel->reset()->select('t1.*')
											 ->where('t1.model','pjOption')
											 ->where('t1.locale', $this->getLocaleId())
											 ->where('t1.field', 'o_reminder_sms_message')
											 ->limit(0, 1)
											 ->findAll()->getData();
											 
					$message = str_replace($data['search'], $data['replace'], $lang_message[0]['content']);
					
					$this->requestAction(array(
												'controller' => 'pjSms',
												'action' => 'pjActionSend',
												'params' => array(
													'number' => $booking_arr['c_phone'],
													'text' => $message,
													'type' => 'unicode',
													'key' => md5($option_arr['private_key'] . PJ_SALT)
												)
											), array('return'));
											
					$pjBookingModel	->reset()
										->setAttributes(array('id' => $booking_arr['id']))
										->modify(array('reminder_sms' => 1));
				}
			}
		}
	}
}
?>