var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var tOpts = {},
			$frmUpdateMap = $("#frmUpdateMap"),
			$dialogUpdate = $("#dialogUpdate"),
			$dialogDel = $("#dialogDelete"),
			$boxMap = $("#boxMap"),
			tabs = ($.fn.tabs !== undefined),
			$tabs = $("#tabs");
	
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs();
		}
		
		function collisionDetect(o) {
			var i, pos, horizontalMatch, verticalMatch, collision = false;
			$("#mapHolder").children("span").each(function (i) {
				pos = getPositions(this);
				horizontalMatch = comparePositions([o.left, o.left + o.width], pos[0]);
				verticalMatch = comparePositions([o.top, o.top + o.height], pos[1]);			
				if (horizontalMatch && verticalMatch) {
					collision = true;
					return false;
				}
			});
			if (collision) {
				return true;
			}
			return false;
		}
		function getPositions(box) {
			var $box = $(box);
			var pos = $box.position();
			var width = $box.width();
			var height = $box.height();
			return [[pos.left, pos.left + width], [pos.top, pos.top + height]];
		}
		
		function comparePositions(p1, p2) {
			var x1 = p1[0] < p2[0] ? p1 : p2;
			var x2 = p1[0] < p2[0] ? p2 : p1;
			return x1[1] > x2[0] || x1[0] === x2[0] ? true : false;
		}
		
		function updateElem(event, ui) {
			var $this = $(this),
				rel = $this.attr("rel"),
				$hidden = $("#" + rel),
				val = $hidden.val().split("|");				
			$hidden.val([val[0], parseInt($this.width(), 10), parseInt($this.height(), 10), ui.position.left, ui.position.top, $this.text(), val[6], val[7]].join("|"));
		}
		function getMax() {
			var tmp, index = 0;
			$("span.empty").each(function (i) {
				tmp = parseInt($(this).attr("rel").split("_")[1], 10);
				if (tmp > index) {
					index = tmp;
				}
			});
			return index;
		}
		
		if ($frmUpdateMap.length > 0) {
			
			$frmUpdateMap.validate();
			tOpts = $.extend(tOpts, {
				select: function (event, ui) {
					$(":input[name='tab_id']").val(ui.panel.id);
				}
			});
			
			if ($dialogDel.length > 0) {
				$dialogDel.dialog({
					autoOpen: false,
					resizable: false,
					draggable: false,
					modal: true,
					buttons: (function () {
						var buttons = {};
						buttons[rbApp.locale.button.delete] = function () {
							$.ajax({
								type: "POST",
								data: {
									id: $dialogDel.data('lang')
								},
								url: "index.php?controller=pjAdminMaps&action=pjActionDeleteFile",
								success: function (data) {
									if (data.code && data.code == 7) {
										
									} else {
										$boxMap.html(data);
									}
								}
							});
							$dialogDel.dialog('close');	
						};
						buttons[rbApp.locale.button.cancel] = function () {
							$dialogDel.dialog('close');	
						};
						
						return buttons;
					})()
				});
			}
			
			if ($dialogUpdate.length > 0) {
				$dialogUpdate.dialog({
					autoOpen: false,
					resizable: false,
					draggable: false,
					modal: true,
					width: 440,
					open: function () {
						var rel = $(this).data("rel"),
							arr = $("#" + rel).val().split("|");
						$("#seat_name").val(arr[5]);
						$("#seat_seats").val(arr[6]);
						$("#seat_minimum").val(arr[7]);
					},
					close: function () {
						$("#seat_name, #seat_seats, #seat_minimum").val("");
										
					},
					buttons: (function () {
						var buttons = {};
						buttons[rbApp.locale.button.save] = function () {
							var rel = $dialogUpdate.data("rel"),
								pName = $("#seat_name").val(),
								pSeats = parseInt($("#seat_seats").val(), 10),
								pMin = parseInt($("#seat_minimum").val(), 10),
								pHidden = $("#" + rel, $frmUpdateMap).val();
							if(pSeats >= pMin)
							{
								$.post("index.php?controller=pjAdminMaps&action=pjActionSaveSeat", {
									"map_id": $(":input[name='id']", $frmUpdateMap).val(),
									"hidden": pHidden,
									"name": pName,
									"seats": pSeats,
									"minimum": pMin
								}).done(function (data) {
									if (!data.code) {
										return;
									}
									switch (parseInt(data.code, 10)) {
										case 200:
										case 201:
											var a = pHidden.split("|");
											var $rect_inner = $(".rbInnerRect[data-name='" + rel + "']", $frmUpdateMap);
											$rect_inner.text(pName);
											$("#rbInner_" + rel).text(pName);
											$("#" + rel).val([data.id, a[1], a[2], a[3], a[4], pName, pSeats, pMin].join("|"));
											$("input[name='m_name[" + data.id + "]']", $frmUpdateMap).val(pName);
											$("input[name='m_seats[" + data.id + "]']", $frmUpdateMap).val(pSeats);
											
											$('#validate_seats').css('display', 'none');
											$('#validate_seats').parent().css('display', 'none');
											break;
									}
								});
								$dialogUpdate.dialog('close');
							}else{
								$('#validate_seats').css('display', 'block');
								$('#validate_seats').parent().css('display', 'block');
							}
						};
						buttons[rbApp.locale.button.delete] = function () {
							var rel = $dialogUpdate.data('rel');
							if (rel.split("_")[0] == 'hi') {
								$.post("index.php?controller=pjAdminMaps&action=pjActionDeleteSeat", {
									id: rel.split("_")[1]
								});
							}
							$("#" + rel, $("#hiddenHolder")).remove();				
							$(".rect-selected[rel='"+ rel +"']", $("#mapHolder")).remove();
							
							$('#validate_seats').css('display', 'none');
							$('#validate_seats').parent().css('display', 'none');
							$dialogUpdate.dialog('close');
						};
						buttons[rbApp.locale.button.cancel] = function () {
							$('#validate_seats').css('display', 'none');
							$('#validate_seats').parent().css('display', 'none');
							$dialogUpdate.dialog('close');	
						};
						
						return buttons;
					})()
				});
			}
			
			var offset = $("#map").offset(),
				dragOpts = {
					containment: "parent",
					stop: function (event, ui) {
						updateElem.apply(this, [event, ui]);
					}
				};
			$("span.empty").draggable(dragOpts).resizable({
				resize: function(e, ui) {
					var height = $(this).height();
					$(this).css("line-height", height + "px"); 
		        },
				stop: function(e, ui) {
					var height = $(this).height();
					$(this).css("line-height", height + "px");
					updateElem.apply(this, [e, ui]);
		        }
			}).bind("click", function (e) {
				$dialogUpdate.data('rel', $(this).attr("rel")).dialog("open");
				$(this).siblings(".rect").removeClass("rect-selected").end().addClass("rect-selected");
			});
			
			$("#mapHolder").click(function (e) {
				
				var $this = $(this),
				index = getMax(),
				t = Math.ceil(e.pageY - offset.top - 13),
				l = Math.ceil(e.pageX - offset.left - 8),
				w = 30,
				h = 30,
				o = {top: t, left: l, width: w, height: h};
				if (!collisionDetect(o)) {
					index++;
					$("<span>", {
						css: {
							"top": t + "px",
							"left": l + "px",
							"width": w + "px",
							"height": h + "px",
							"line-height": h + "px",
							"position": "absolute"
						},
						html: '<span class="rbInnerRect" data-name="hidden_'+index+'">'+index+'</span>',
						rel: "hidden_" + index
					}).addClass("rect empty new").draggable(dragOpts).resizable({
						resize: function(e, ui) {
							var height = $(this).height();
							$(this).css("line-height", height + "px"); 
				        },
						stop: function(e, ui) {
							var height = $(this).height();
							$(this).css("line-height", height + "px"); 
							updateElem.apply(this, [e, ui]);
				        }
					}).bind("click", function (e) {
						$dialogUpdate.data('rel', $(this).attr("rel")).dialog("open");
						$(this).siblings(".rect").removeClass("rect-selected").end().addClass("rect-selected");
					}).appendTo($this);
					
					$("<input>", {
						type: "hidden",
						name: "seats_new[]",
						id: "hidden_" + index
					}).val(['x', w, h, l, t, index, '1', '1'].join("|")).appendTo($("#hiddenHolder"));
					
				} else {
					if (window.console && window.console.log) {
						//console.log('Collision detected');
					}
				}
			});
		}
		$('#resizeDiv').resizable({
		        start: function(e, ui) {
		            alert('resizing started');
		        },
		        resize: function(e, ui) {
		         
		        },
		        stop: function(e, ui) {
		            alert('resizing stopped');
		        }
	    });
		$(document).on("click", ".pj-delete-button", function (e) {
			$dialogDel.data('lang', $(this).attr('lang')).dialog('open');
		});
	});
})(jQuery_1_8_2);